package Facade;

class OnlineOrderFacade {
    private InventorySystem inventorySystem;
    private PricingSystem pricingSystem;
    private DiscountSystem discountSystem;
    private OrderSystem orderSystem;
    private PaymentSystem paymentSystem;

    public OnlineOrderFacade() {
        this.inventorySystem = new InventorySystem();
        this.pricingSystem = new PricingSystem();
        this.discountSystem = new DiscountSystem();
        this.orderSystem = new OrderSystem();
        this.paymentSystem = new PaymentSystem();
    }

    public void placeOrder(String product, int quantity, String couponCode) {
        boolean isAvailable = inventorySystem.checkInventory(product, quantity);
        if (isAvailable) {
            double totalPrice = pricingSystem.calculateTotalPrice(product, quantity);
            totalPrice = discountSystem.applyDiscount(totalPrice, couponCode);
            orderSystem.generateOrder(product, quantity);
            paymentSystem.processPayment(totalPrice);
            System.out.println("Ordine completato per " + quantity + " di " + product);
        } else {
            System.out.println("Prodotto non disponibile nell'inventario.");
        }
    }
}